using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywoanie programu: Program plik");
      return;
    }
    String plik = args[0];

    BinaryWriter bw;
    try
    {
      bw = new BinaryWriter(new FileStream(plik, FileMode.Create));
    }
    catch(Exception)
    {
      Console.WriteLine("Otwarcie pliku {0} nie powiodo si.", plik);
      return;
    }

    try
    {
      Console.WriteLine("Wprowadzaj wartoci cakowite. Wpisz 'quit' by zakoczy.");

      String line = "";
      while(line != "quit")
      {
        Console.Write("Wprowad warto cakowit: ");
        int wartosc;
        line = Console.ReadLine();
        if(line == "quit")
        {
          break;
        }
        try
        {
          wartosc = Int32.Parse(line);
        }
        catch(Exception)
        {
          Console.WriteLine("To nie jest prawidowa warto cakowita.");
          continue;
        }
        bw.Write(wartosc);
      }
      bw.Close();
    }
    catch(Exception)
    {
      Console.WriteLine("Wystpi bd w trakcie przetwarzania danych.");
      return;
    }
    Console.WriteLine("Zapis zosta dokonany.");
  }
}
